package gov.va.genisis2.dao;

import java.util.List;

import gov.va.genisis2.exceptions.GenisisDAOException;
import gov.va.genisis2.model.User;
import gov.va.genisis2.model.UserCount;

/**
 * @author Getaneh Kassahun
 *
 */
public interface IUserManagementDao {
	public User getUserDetailsByEmail(String email) throws GenisisDAOException;

	public User getUserDetailsById(int id) throws GenisisDAOException;

	public String getUserRole(int uid) throws GenisisDAOException;

	public User getUserDetailsByUsername(String username) throws GenisisDAOException;

	public List<UserCount> getUserCountOnRole() throws GenisisDAOException;
	
	public List<User> getUserDetailsByRoleTypeId(int roleTypeId) throws GenisisDAOException;
	
	public List<User> getAllUsers() throws GenisisDAOException;
	
	public User saveOrUpdate(User user) throws GenisisDAOException;
	
	public int updateUserStatus(List<String> usersList) throws GenisisDAOException;
}
